/**********************************************************************
*	Bastion Products Copyright 1998								*
*	All rights reserved										*
*	This source is freely distributable in an unmodified state.		*
*	Project:			Blithe Shared Library						*
*	Source:			VuBackdrop.cpp							*
*	Last Modified:	5/23/98									*
*	Author:			Greg Weston								*
*	Description:		This project creates a shared library which	*
*					allows applications to have dynamic text in	*
*					different languages.						*
***********************************************************************/
#include "VuBackdrop.h"
#include <Window.h>

/**********************************************************************
*	Method:		VuBackdrop									*
*	Arguments:	<none>										*
*	Returns:		<none>										*
*	Description:	Sets up a BView which fills the window with a given	*
*				level of grey									*
**********************************************************************/
VuBackdrop::VuBackdrop(BWindow* inWindow, uchar inGrey)
	: BView(BRect(0,0,20,20),"backdrop",B_FOLLOW_ALL_SIDES,B_WILL_DRAW)
{
	SetViewColor(inGrey,inGrey,inGrey);
	BRect wRect = inWindow->Bounds();
	ResizeTo(wRect.right,wRect.bottom);
	inWindow->AddChild(this);
}
